/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.epsilon;

import com.alcatrazescapee.epsilon.ParseError;
import com.alcatrazescapee.epsilon.ValueConverter;
import com.alcatrazescapee.epsilon.value.TypeValue;
import com.alcatrazescapee.epsilon.value.Value;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;

public interface Type<T> {
    public static final Type<Boolean> BOOL = token -> {
        if (token instanceof Boolean) {
            Boolean boolValue = (Boolean)token;
            return boolValue;
        }
        throw new ParseError("Cannot convert " + String.valueOf(token) + " to boolean");
    };
    public static final Type<Integer> INT = token -> {
        if (token instanceof Integer) {
            Integer intValue = (Integer)token;
            return intValue;
        }
        throw new ParseError("Cannot convert " + String.valueOf(token) + " to int");
    };
    public static final Type<Float> FLOAT = token -> {
        if (token instanceof Float) {
            Float floatValue = (Float)token;
            return floatValue;
        }
        if (token instanceof Integer) {
            Integer intValue = (Integer)token;
            return Float.valueOf(intValue.floatValue());
        }
        throw new ParseError("Cannot convert " + String.valueOf(token) + " to float");
    };
    public static final Type<String> STRING = new Type<String>(){

        @Override
        public String parse(Object token) {
            if (token instanceof String) {
                String string = (String)token;
                return string;
            }
            throw new ParseError("Cannot convert " + String.valueOf(token) + " to string");
        }

        @Override
        public String write(String value) {
            return "\"%s\"".formatted(StringEscapeUtils.escapeJava((String)value));
        }
    };
    public static final Type<List<String>> STRING_LIST = STRING.listOf();

    public static <T> Type<List<T>> list(final Type<T> elementType) {
        return new Type<List<T>>(){

            @Override
            public List<T> parse(Object token) {
                if (token instanceof List) {
                    List value = (List)token;
                    return value.stream().map(elementType::parse).toList();
                }
                throw new ParseError("Cannot convert " + String.valueOf(token) + " to list");
            }

            @Override
            public String write(List<T> value) {
                Object[] objectArray = new Object[1];
                objectArray[0] = value.stream().map(elementType::write).collect(Collectors.joining(", "));
                return "[%s]".formatted(objectArray);
            }
        };
    }

    public T parse(Object var1) throws ParseError;

    default public String write(T value) {
        return String.valueOf(value);
    }

    default public Type<List<T>> listOf() {
        return Type.list(this);
    }

    default public <V extends Value<T>> ValueConverter<T, T, V> map(Function<T, V> factory) {
        return this.map(Function.identity(), Function.identity(), factory);
    }

    default public <V extends Value<T>> ValueConverter<T, T, V> map(Consumer<T> parseFunction, Function<T, V> factory) {
        return this.map(t -> {
            parseFunction.accept(t);
            return t;
        }, Function.identity(), factory);
    }

    default public <U> ValueConverter<T, U, TypeValue<U>> map(Function<T, U> parseFunction, Function<U, T> writeFunction) {
        return this.map(parseFunction, writeFunction, TypeValue::new);
    }

    default public <U, V extends Value<U>> ValueConverter<T, U, V> map(Function<T, U> parseFunction, Function<U, T> writeFunction, Function<U, V> factory) {
        return new ValueConverter<T, U, V>(this, parseFunction, writeFunction, factory);
    }
}

